program delphiTthread;
{$APPTYPE CONSOLE}

//
// This example demonstrates how write a threaded application using the
// TThread class. 
// 
// Written by: Rick Ross (http://www.rick-ross.com/)
//

uses
  SysUtils, Classes;

type
  TThreadMe = class(TThread)
  private
    FStartNum: integer;
  protected
    procedure Execute; override;
  public
    property StartNum : integer write FStartNum;
  end;

{ TThreadMe }

procedure TThreadMe.Execute;
var
  stop : integer;
  curNum : integer;

begin
  curNum := FStartNum;
  stop := FStartNum + 10;
  while curNum < stop do
  begin
    writeln('Thread ', AppDomain.GetCurrentThreadID() ,' current value is ',curNum);
    inc(curNum);
    Sleep( 3 );
  end;
end;

var
  thrd : TThreadMe;
  thrd2 : TThreadMe;

begin
  writeln('Staring TThread example...');

  // create TThreadMe instance
  thrd := TThreadMe.create(false);
  thrd.StartNum := 10;

  thrd2 := TThreadMe.create(false);
  thrd2.StartNum := 100;

  thrd.Resume;
  thrd2.Resume;

  readln;
  writeln('Done');
end.

